/*
	icst.distance_encoding.js : part of the ICST Ambisonics tools 
	- replaces lcd-based version

	(c) 2021 ICST Zurich University of the Arts
*/
autowatch=0;inlets=1;outlets=3;mgraphics.init();mgraphics.relative_coords=0;mgraphics.autofill=0;function Point(){this.x=0.0;this.y=0.0;this.z=0.0}function Rectangle(){this.x1=0.0;this.y1=0.0;this.x2=1.0;this.y2=1.0}var bgcolor=[0.0,0.125,0.25,1.0];var linecolor=[0.75,0.9,1.0,1.0];var linecolor2=[1.0,0.6,0.4,1.0];var textcolor=[1.0,1.0,1.0,0.5];var gridcolor=[0.5,0.75,1.0,0.5];var markercolor=[1.0,0.9,0.0,1.0];var textSize;var gWidth;var gHeight;var gBox=new Point();var gNumUnits;var gAspect;var distanceMode=1;var ambiType=1;var dbUnit=6;var distAtt=1.4;var centerSize=1.0;var centerCurve=0.33;var centerAttDb=18;var expFactor=0.01;var expPower=10;var expCutoffDist=100.0;var expCurve=1.0;var viewMode=1;var viewScale=new Point();var viewInitialScale=new Point();var xScale;var viewOffset=new Point();var viewBorder=new Point();var curve1=[];var curve1Count;var curve2=[];var curve2Count;var w_gain;var g_gain;var stepSizeLin;var multiplierLin;var numBarsLog;var stepSizeLog;var multiplierLog;var unitMark;var dragging=0;var storedMouse=new Point();var haveGUI_Type=1;var haveGUI_Mode=1;var haveGUI_P1=1;var haveGUI_P1Label=1;var haveGUI_P2=1;var haveGUI_P2Label=1;var haveGUI_P3=1;var haveGUI_P3Label=1;var haveMarker=0;var resultValues=new Point();function init(){textSize=9.5;viewOffset.x=28;viewOffset.y=25;viewBorder.x=1;viewBorder.y=textSize+1;viewScale.y=50.;viewScale.x=10;viewInitialScale.x=4;viewInitialScale.y=36;calcAspect();calcCurve();mgraphics.redraw()}init();function bang(){}function msg_float(f){var dist=Math.max(f,0.0);calcAttenuation(dist);if(dist==0.0&&distanceMode>0){g_gain=0.0;w_gain=1.0;if(ambiType==0){w_gain=Math.sqrt(2.0)/2.}}else if(distanceMode==0){g_gain=1.0;w_gain=1.0;if(ambiType==0){w_gain=Math.sqrt(2.0)/2.}}resultValues.x=g_gain;resultValues.y=w_gain;resultValues.z=dist;haveMarker=1;outlet(0,w_gain,g_gain);mgraphics.redraw()}function paint(){var i,j,k;with(mgraphics){select_font_face("Arial");set_font_size(textSize);set_source_rgba(bgcolor);rectangle(0,0,gWidth+1,gHeight+1);fill();set_source_rgba(0.5,0.75,1,0.2);rectangle(viewOffset.x,viewOffset.y,gBox.y*centerSize*xScale,gBox.y);fill();set_source_rgba(gridcolor);move_to(viewOffset.x,viewOffset.y);line_to(gWidth-viewBorder.x,viewOffset.y);stroke();move_to(viewOffset.x,gBox.y+viewOffset.y);line_to(gWidth-viewBorder.x,gBox.y+viewOffset.y);stroke();move_to(viewOffset.x,viewOffset.y);line_to(viewOffset.x,gHeight-viewBorder.y);stroke();move_to(gWidth-viewBorder.x,viewOffset.y);line_to(gWidth-viewBorder.x,gHeight-viewBorder.y);stroke();var gNumUnits=Math.floor(gBox.x/(gBox.y*xScale));var unitExtent=gBox.x/viewScale.x;for(i=1;i<=gNumUnits;i+=1){set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]*0.5);move_to(i*gBox.y*xScale+viewOffset.x,viewOffset.y);line_to(i*gBox.y*xScale+viewOffset.x,gHeight-viewBorder.y);stroke()}if(viewMode==0){for(i=0;i<11;i+=1){set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]*0.25);move_to(viewOffset.x,(i*stepSizeLin)+viewOffset.y);line_to(viewOffset.x+gBox.x,(i*stepSizeLin)+viewOffset.y);stroke();set_source_rgba(textcolor);move_to(5,(i*stepSizeLin)+viewOffset.y+3);if((i*stepSizeLin)>gBox.y){move_to(5,viewOffset.y+gBox.y+3);show_text("0.00");break}show_text((1.-i*0.1*multiplierLin).toFixed(2))}}else if(viewMode==1){set_source_rgba(textcolor);move_to(7.5,viewOffset.y+4);show_text("0.0");for(i=1;i<numBarsLog;i+=1){set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]*0.25);move_to(viewOffset.x,(i*stepSizeLog)+viewOffset.y);line_to(gBox.x+viewOffset.x,(i*stepSizeLog)+viewOffset.y);stroke();set_source_rgba(textcolor);move_to(2,(i*stepSizeLog)+viewOffset.y+3.0);if((i*stepSizeLog)>=gBox.y-textSize-1){break}show_text((i*-3.0*multiplierLog).toFixed(1))}set_source_rgba(textcolor);move_to(2,viewOffset.y+gBox.y+3);show_text((viewScale.y*-1.0).toFixed(1))}if(viewMode==0){set_source_rgba(linecolor2);move_to(curve1[0].x*gBox.y*xScale+viewOffset.x,gBox.y-(curve1[0].y*gBox.y)+viewOffset.y);for(i=1;i<curve1Count;i+=1){line_to(curve1[i].x*gBox.y*xScale+viewOffset.x,gBox.y-(curve1[i].y*gBox.y)+viewOffset.y)}stroke();set_source_rgba(linecolor);move_to(curve2[0].x*gBox.y+viewOffset.x,gBox.y-(curve2[0].y*gBox.y)+viewOffset.y);for(i=1;i<curve2Count;i+=1){line_to(curve2[i].x*gBox.y*xScale+viewOffset.x,gBox.y-(curve2[i].y*gBox.y)+viewOffset.y)}stroke()}else if(viewMode==1){set_source_rgba(linecolor2);move_to(curve1[0].x*gBox.y*xScale+viewOffset.x,gBox.y-(to_log_view(curve1[0].y)*gBox.y)+viewOffset.y);for(i=1;i<curve1Count;i+=1){line_to(curve1[i].x*gBox.y*xScale+viewOffset.x,gBox.y-(to_log_view(curve1[i].y)*gBox.y)+viewOffset.y)}stroke();set_source_rgba(linecolor);move_to(curve2[0].x*gBox.y*xScale+viewOffset.x,gBox.y-(to_log_view(curve2[0].y)*gBox.y)+viewOffset.y);for(i=1;i<curve2Count;i+=1){line_to(curve2[i].x*gBox.y*xScale+viewOffset.x,gBox.y-(to_log_view(curve2[i].y)*gBox.y)+viewOffset.y)}stroke()}set_source_rgba(bgcolor);rectangle(viewOffset.x,gBox.y+viewOffset.y,gBox.x,viewBorder.y);fill();set_source_rgba(textcolor);move_to(viewOffset.x,gHeight-1);show_text("0");for(i=1;i<=gNumUnits;i+=1){set_source_rgba(textcolor);move_to(i*gBox.y*xScale+viewOffset.x,gHeight-1);show_text(i.toFixed(0))}if(haveMarker==1){set_source_rgba(markercolor);var a,b;if(viewMode==0){a=resultValues.x;b=resultValues.y}else{a=to_log_view(resultValues.x);b=to_log_view(resultValues.y)}ellipse(resultValues.z*gBox.y*xScale+viewOffset.x-3,gBox.y-(a*gBox.y)+viewOffset.y-3,6,6);stroke();ellipse(resultValues.z*gBox.y*xScale+viewOffset.x-3,gBox.y-(b*gBox.y)+viewOffset.y-3,6,6);stroke()}set_source_rgba(textcolor);move_to(3,16);show_text("mode");set_source_rgba(gridcolor);rectangle(viewOffset.x+1,4,16,16);stroke();rectangle(viewOffset.x+19,4,16,16);stroke();rectangle(viewOffset.x+37,4,16,16);stroke();rectangle(viewOffset.x+55,4,16,16);stroke();set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]*0.6666);rectangle(viewOffset.x+1+(distanceMode*18),4,16,16);fill();set_source_rgba(textcolor);move_to(viewOffset.x+6,16);show_text("0");move_to(viewOffset.x+24,16);show_text("1");move_to(viewOffset.x+42,16);show_text("2");move_to(viewOffset.x+60,16);show_text("3");move_to(viewOffset.x+75,16);if(distanceMode==0){show_text("no change")}else if(distanceMode==1){show_text("exponential")}else if(distanceMode==2){show_text("inverse proport'l")}else if(distanceMode==3){show_text("exp. pow. smooth")}if(haveGUI_Type){set_source_rgba(gridcolor);rectangle(viewOffset.x+gBox.x-120,4,66,16);stroke();set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]*0.5);rectangle(viewOffset.x+gBox.x-120+ambiType*33,4,33,16);fill();set_source_rgba(textcolor);move_to(viewOffset.x+gBox.x-115,16);show_text("FuMa");move_to(viewOffset.x+gBox.x-85,16);show_text("AmbiX")}if(haveGUI_Mode){set_source_rgba(gridcolor);rectangle(viewOffset.x+gBox.x-50,4,46,16);stroke();set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]*0.5);rectangle(viewOffset.x+gBox.x-50+viewMode*25,4,22,16);fill();set_source_rgba(textcolor);move_to(viewOffset.x+gBox.x-44,16);show_text("lin");move_to(viewOffset.x+gBox.x-20,16);show_text("log")}set_source_rgba(0.0,0.8,0.4,0.75);move_to(unitMark+viewOffset.x,gBox.y+viewOffset.y);line_to(unitMark+viewOffset.x,viewOffset.y);stroke();set_source_rgba(textcolor);move_to(unitMark+viewOffset.x+2,gBox.y+viewOffset.y-12);show_text((centerSize.toFixed(2)));move_to(unitMark+viewOffset.x+3,gBox.y+viewOffset.y-2);show_text("unit radius");if(distanceMode>0&&haveGUI_P1){var textbox;var textoffset;set_source_rgba(gridcolor);rectangle(viewOffset.x+160,4,48,16);move_to(viewOffset.x+160,4);line_to(viewOffset.x+166,12);line_to(viewOffset.x+160,20);stroke();set_source_rgba(textcolor);if(distanceMode==1){textbox=text_measure(dbUnit.toFixed(2));textoffset=(48-textbox[0])*0.5;move_to(viewOffset.x+160+textoffset,16);show_text((dbUnit.toFixed(2)));if(gWidth>274){move_to(240,16);show_text("dB unit")}}else if(distanceMode==2){textbox=text_measure(distAtt.toFixed(2));textoffset=(48-textbox[0])*0.5;move_to(viewOffset.x+160+textoffset,16);show_text((distAtt.toFixed(2)));if(gWidth>300){move_to(240,16);show_text("distance atten.")}}else if(distanceMode==3){textbox=text_measure(expCutoffDist.toFixed(2));textoffset=(48-textbox[0])*0.5;move_to(viewOffset.x+160+textoffset,16);show_text((expCutoffDist.toFixed(2)));if(haveGUI_P1Label){move_to(239,16);show_text("cutoff distance")}}if(haveGUI_P2){set_source_rgba(gridcolor);rectangle(viewOffset.x+278,4,46,16);move_to(viewOffset.x+278,4);line_to(viewOffset.x+284,12);line_to(viewOffset.x+278,20);stroke();set_source_rgba(textcolor);if(distanceMode==1||distanceMode==2){textbox=text_measure(centerCurve.toFixed(2));textoffset=(48-textbox[0])*0.5;move_to(viewOffset.x+276+textoffset,16);show_text((centerCurve.toFixed(2)));if(haveGUI_P2Label){move_to(356,16);show_text("center curve")}}else if(distanceMode==3){textbox=text_measure(expCurve.toFixed(2));textoffset=(48-textbox[0])*0.5;move_to(viewOffset.x+276+textoffset,16);show_text((expCurve.toFixed(2)));if(haveGUI_P2Label){move_to(356,16);show_text("exp. curve")}}}if(haveGUI_P3){if(distanceMode==1||distanceMode==2){set_source_rgba(gridcolor);rectangle(viewOffset.x+385,4,46,16);move_to(viewOffset.x+385,4);line_to(viewOffset.x+391,12);line_to(viewOffset.x+385,20);stroke();set_source_rgba(textcolor);textbox=text_measure(centerAttDb.toFixed(2));textoffset=(48-textbox[0])*0.5;move_to(viewOffset.x+385+textoffset,16);show_text((centerAttDb.toFixed(2)));if(haveGUI_P3Label){move_to(462,16);show_text("center atten.")}}}}}}function onclick(x,y,button,mod1,shift,caps,opt,mod2){if(x>viewOffset.x&&y>viewOffset.y){if(x>unitMark+viewOffset.x-4&&x<unitMark+viewOffset.x+4){if(y>viewOffset.y-12&&y<gBox.y+viewOffset.y){dragging=2;}}else{dragging=1;}storedMouse.x=x;storedMouse.y=y;}else if(y<=viewOffset.y){if(haveGUI_Mode){if(x>(viewOffset.x+gBox.x-44)){if(x<(viewOffset.x+gBox.x-20)){view_mode(0);mgraphics.redraw()}else{view_mode(1);mgraphics.redraw()}}}if(haveGUI_Type){if(x>(viewOffset.x+gBox.x-120)){if(x<(viewOffset.x+gBox.x-87)){type(0);mgraphics.redraw()}else{type(1);mgraphics.redraw()}}}if(haveGUI_P1&&distanceMode>0){if(x>viewOffset.x+160&&x<viewOffset.x+184){dragging=3;}else if(x>viewOffset.x+185&&x<viewOffset.x+208){dragging=4;}}if(haveGUI_P2&&distanceMode>0){if(x>viewOffset.x+278&&x<viewOffset.x+301){dragging=5;}else if(x>viewOffset.x+302&&x<viewOffset.x+324){dragging=6;}}if(haveGUI_P3&&(distanceMode==1||distanceMode==2)){if(x>viewOffset.x+385&&x<viewOffset.x+408){dragging=7;}else if(x>viewOffset.x+409&&x<viewOffset.x+431){dragging=8;}}if(x>(viewOffset.x+1)&&x<=(viewOffset.x+71)){var xx=Math.floor(((x-viewOffset.x)/70)*4);distance_mode(xx);calcAspect();mgraphics.redraw()}}}function ondrag(x,y,button,mod1,shift,caps,opt,mod2){var delta_x;var delta_y;if(button==1){if(mod1==0&&opt==0&&mod2==0){delta_y=y-storedMouse.y;delta_y=clip(delta_y,-1,1);if(dragging==2){unitMark=x-viewOffset.x;center_size(unitMark/(xScale*gBox.y));mgraphics.redraw()}else if(dragging==3){if(distanceMode==1){db_unit(dbUnit+delta_y)}else if(distanceMode==2){dist_att(distAtt+delta_y)}else if(distanceMode==3){exp_cutoff_dist(expCutoffDist-delta_y)}}else if(dragging==4){if(distanceMode==1){db_unit(dbUnit+(delta_y*0.01))}else if(distanceMode==2){dist_att(distAtt+(delta_y*0.01))}else if(distanceMode==3){exp_cutoff_dist(expCutoffDist-(delta_y*0.01))}}else if(dragging==5){if(distanceMode==1||distanceMode==2){center_curve(centerCurve+delta_y)}else if(distanceMode==3){exp_curve(expCurve+delta_y)}}else if(dragging==6){if(distanceMode==1||distanceMode==2){center_curve(centerCurve+(delta_y*0.01))}else if(distanceMode==3){exp_curve(expCurve+(delta_y*0.01))}}else if(dragging==7){center_att_db(centerAttDb+delta_y)}else if(dragging==8){center_att_db(centerAttDb+(delta_y*0.01))}storedMouse.x=x;storedMouse.y=y}else if(mod1==1&&dragging==1){delta_x=x-storedMouse.x;delta_y=y-storedMouse.y;var xx=viewScale.x-delta_x*0.01;if(viewMode==1){var yy=viewScale.y-delta_y*0.05}else{var yy=viewScale.y}view_scale(xx,-yy);calcCurve();storedMouse.x=x;storedMouse.y=y;}else if(opt==1){}}else if(button==0){dragging=0}}function ondblclick(x,y,button,mod1,shift,caps,opt,mod2){if(x>unitMark+viewOffset.x-4&&x<unitMark+viewOffset.x+4){if(y>viewOffset.y-12&&y<gBox.y+viewOffset.y){center_size(1);return}}viewScale.x=viewInitialScale.x;xScale=viewInitialScale.x/viewScale.x;viewScale.y=36;unitMark=gBox.y*centerSize*xScale;calcCurve();mgraphics.redraw();}function onresize(gWidth,gHeight){var w=box.rect[2]-box.rect[0];var h=box.rect[3]-box.rect[1];w=Math.max(w,185);h=Math.max(h,80);box.size(w,h);viewScale.y=36;calcAspect();calcCurve()}function calcAspect(){gWidth=this.box.rect[2]-this.box.rect[0];gHeight=this.box.rect[3]-this.box.rect[1];gAspect=gWidth/gHeight;gBox.y=gHeight-viewOffset.y-viewBorder.y;gBox.x=gWidth-viewOffset.x-viewBorder.x;viewInitialScale.x=gBox.x/gBox.y;gNumUnits=Math.floor(viewInitialScale.x);unitMark=gBox.y*centerSize*xScale;if(distanceMode==1||distanceMode==2){haveGUI_Type=gWidth>637?1:0;haveGUI_Mode=gWidth>570?1:0;}else if(distanceMode==3){haveGUI_Type=gWidth>528?1:0;haveGUI_Mode=gWidth>458?1:0;}haveGUI_P3Label=gWidth>524?1:0;haveGUI_P3=gWidth>456?1:0;haveGUI_P2Label=gWidth>410?1:0;haveGUI_P2=gWidth>350?1:0;haveGUI_P1Label=gWidth>300?1:0;haveGUI_P1=gWidth>235?1:0;if(haveMarker==1){msg_float(resultValues.z)}}function calcCurve(){var distance;var stepsize=0.01;var numsteps=viewScale.x/stepsize;while(numsteps>1000){numsteps*=0.5;stepsize*=2.0}curve1.length=0;curve2.length=0;for(var i=0;i<numsteps+1;i+=1){distance=i*stepsize;gains=calcAttenuation(distance);var newPt1=new Point();newPt1.x=i*stepsize;newPt1.y=w_gain;curve1.push(newPt1);var newPt2=new Point();newPt2.x=i*stepsize;newPt2.y=g_gain;curve2.push(newPt2)}curve1Count=numsteps+1;curve2Count=numsteps+1;stepSizeLin=0.1*gBox.y;multiplierLin=1;while(stepSizeLin<8.5){stepSizeLin*=2.5;multiplierLin*=2.5}numBarsLog=(viewScale.y/3.)+1;stepSizeLog=gBox.y/(numBarsLog-1);multiplierLog=1;while(stepSizeLog<8.5){numBarsLog*=0.6666666667;stepSizeLog*=1.5;multiplierLog*=1.5}if(haveMarker==1){msg_float(resultValues.z)}mgraphics.redraw()}calcCurve.immediate=1;function calcAttenuation(distance){var wFactor;var centerAtt=Math.pow(10.0,(-centerAttDb/20.0));if(ambiType==1){wFactor=1.0;}else if(ambiType==0){wFactor=Math.sqrt(2.)*0.5}if(distanceMode==0){w_gain=wFactor;g_gain=1.0;return}else if(distanceMode==3){var scaledDistance=distance*(1.0/centerSize);var scalar;if(distance==0.0){w_gain=1.0;g_gain=0.0;if(ambiType==0){w_gain=Math.sqrt(2.0)/2.}return}else if(distance<=centerSize){scalar=1.0}else{expFactor=1.0/clip((expCutoffDist-1.0),0.0,1000);scalar=Math.pow((1.0-expFactor*(distance-centerSize)),expCurve);if((1./(distance-centerSize))<expFactor){scalar=0.0}}w_gain=Math.atan(scaledDistance*Math.PI*0.5)/(scaledDistance*Math.PI*0.5)*scalar;g_gain=(1.0-Math.exp(-scaledDistance))*w_gain;w_gain*=wFactor}else {if(distance==0.0){w_gain=wFactor;g_gain=0.0}else if(distance<=centerSize){w_gain=wFactor;g_gain=(Math.pow((distance*(1./centerSize)),centerCurve)*(1-centerAtt))+centerAtt}else {if(distanceMode==1){g_gain=Math.pow(10,(distance-centerSize)* -dbUnit*0.05)}else if(distanceMode==2){g_gain=Math.pow((distance+(1.0-centerSize)),-distAtt)}w_gain=g_gain*wFactor}}}function to_degrees(rad_value){return rad_value*57.2957795130823208}to_degrees.immediate=1;function to_radians(deg_value){return deg_value*0.0174532925199432}to_radians.immediate=1;function clip(f,a,b){return Math.max(Math.min(f,Math.max(a,b)),Math.min(a,b))}function to_log_view(f){if(f==0.0){return-viewScale.y}var result=Math.log(f)/Math.log(10);result*=20.;result=1.-((result/viewScale.y)*-1.0);return result}function type(n){n=Math.floor(n);ambiType=clip(n,0,1);calcCurve();outlet(2,"type",ambiType)}function distance_mode(n){n=Math.floor(n);distanceMode=clip(n,0,3);calcCurve();outlet(1,"distance_mode",distanceMode)}function db_unit(f){dbUnit=Math.max(f,0.0);calcCurve();outlet(1,"db_unit",dbUnit)}function dist_att(f){distAtt=Math.max(f,0);calcCurve();outlet(1,"dist_att",distAtt)}function center_size(f){centerSize=Math.max(f,0.0001);calcCurve();unitMark=gBox.y*centerSize*xScale;outlet(1,"center_size",centerSize)}function center_curve(f){centerCurve=clip(f,0,1);calcCurve();outlet(1,"center_curve",centerCurve)}function center_att_db(f){centerAttDb=clip(f,0.0,96);calcCurve();outlet(1,"center_att_db",centerAttDb)}function exp_cutoff_dist(f){expCutoffDist=Math.max(f,1.001);calcCurve();outlet(1,"exp_cutoff_dist",expCutoffDist)}function exp_curve(f){expCurve=clip(f,0,20.0);calcCurve();outlet(1,"exp_curve",expCurve)}function view_mode(n){n=Math.floor(n);viewMode=clip(n,0,1);calcCurve();outlet(2,"view_mode",viewMode)}function view_scale(x,y){viewScale.x=clip(x,2,100);xScale=viewInitialScale.x/viewScale.x;viewScale.y=clip(y,-96,-12);viewScale.y*=-1.0;unitMark=gBox.y*centerSize*xScale;calcCurve();outlet(2,"view_scale",viewScale.x,-viewScale.y)}function getvalueof(){var state=[];state[0]=ambiType;state[1]=viewMode;state[2]=distanceMode;state[3]=dbUnit;state[4]=distAtt;state[5]=centerSize;state[6]=centerCurve;state[7]=centerAttDb;state[8]=expCutoffDist;state[9]=expCurve;state[10]=viewScale.x;state[11]=viewScale.y;return state}function setvalueof(){var state=arrayfromargs();post("state "+state+"\n")}function save(){embedmessage("savedState",ambiType,distanceMode,dbUnit,distAtt,centerSize,centerCurve,centerAttDb,expCutoffDist,expCurve,viewMode,viewScale.x,viewScale.y)}save.immediate=1;function savedState(){var tmp=arrayfromargs(messagename,arguments);ambiType=tmp[1];distanceMode=tmp[2];dbUnit=tmp[3];distAtt=tmp[4];centerSize=tmp[5];centerCurve=tmp[6];centerAttDb=tmp[7];expCutoffDist=tmp[8];expCurve=tmp[9];viewMode=tmp[10];viewScale.x=tmp[11];viewScale.y=tmp[12];}function loadbang(){type(ambiType);distance_mode(distanceMode);db_unit(dbUnit);dist_att(distAtt);center_size(centerSize);center_curve(centerCurve);center_att_db(centerAttDb);exp_cutoff_dist(expCutoffDist);exp_curve(expCurve);view_mode(viewMode);view_scale(viewScale.x,-viewScale.y);calcAspect();calcCurve();mgraphics.redraw()}